<?php
include 'constants.php';
spl_autoload_register('classLoader');
session_start();

try{
  $portal = new PortalFront("localhost", "php", "test", "ksiegarnia");
  
  $action = 'showMain';
  if (isset($_GET['action'])) {
    $action = $_GET['action'];
  }
  
  $komunikat = $portal->getMessage();
  if(!$komunikat && $action == 'showLoginForm'){
    $komunikat = 'Wprowad e-mail i haso uytkownika';
  }
  
  if(($action == 'showLoginForm' || $action == 'showRegistrationForm' || $action == 'registerUser') && $portal->zalogowany){
    $portal->setMessage('Najpierw prosz si wylogowa.');
    header('Location:index.php?action=showMain');
    return;
  }
  
  switch($action){
    case 'login' : 
      switch($portal->login()){
        case ACTION_OK : 
          $portal->setMessage('Zalogowanie prawidowe');
          header('Location:index.php?action=showMain');
          return;
        case NO_LOGIN_REQUIRED : 
          $portal->setMessage('Najpierw prosz si wylogowa.');
          header('Location:index.php?action=showMain');
          return;
        case ACTION_FAILED :
        case FORM_DATA_MISSING :
          $portal->setMessage('Bdna nazwa lub haso uytkownika');
          break;
        default:
          $portal->setMessage(
            'Bd serwera. Zalogowanie nie jest obecnie moliwe.');
      }
      header('Location:index.php?action=showLoginForm');
      break;
    case 'logout': 
      $portal->logout();
      header('Location:index.php?action=showMain');
      break;
    case 'registerUser':
      switch($portal->registerUser()):
        case ACTION_OK:
          $portal->setMessage('Rejestracja prawidowa. Moesz si teraz zalogowa.');
          header('Location:index.php?action=showLoginForm');
          return;
        case FORM_DATA_MISSING:
          $portal->setMessage('Prosz wypeni wszystkie pola formularza!');
          break;
        case PASSWORDS_DO_NOT_MATCH:
          $portal->setMessage('Haso musi by takie samo w obu polach!');
          break;
        case USER_NAME_ALREADY_EXISTS:
          $portal->setMessage('Podany adres e-email jest ju zarejestrowany!');
          break;
        case ACTION_FAILED:
          $portal->setMessage('Obecnie rejestracja nie jest moliwa.');
          break;
        case SERVER_ERROR:
        default:
          $portal->setMessage('Bd serwera!');
      endswitch;
      header('Location:index.php?action=showRegistrationForm');
      break;
    case 'addToBasket':
      switch($portal->addToBasket()):
        case INVALID_ID:
        case FORM_DATA_MISSING:
          $portal->setMessage('Bdny identyfikator ksiki.');
          break;
        case ACTION_OK:
          $portal->setMessage('Ksika zostaa dodana do koszyka.');
          break;
        default:
          $portal->setMessage('Bd serwera.');
      endswitch;
      header('Location:index.php?action=showBasket');
      break;
    case 'modifyBasket':
      $portal->setMessage('Zawarto koszyka zostaa uaktualniona.');
      $portal->modifyBasket();
      header('Location:index.php?action=showBasket');
      break;
    case 'saveOrder':
      //Zapis zamwienia w bazie danych
      break;
    default:
      include 'templates/mainTemplate.php';
  }
}
catch(Exception $e){
  //echo 'Bd: ' . $e->getMessage();
  exit('Portal chwilowo niedostpny');
}

function classLoader($nazwa){
  if(file_exists("klasy/$nazwa.php")){
    require_once("klasy/$nazwa.php");
  } else {
    throw new Exception("Brak pliku z definicj klasy.");
  }
}
?>
